TITLE 							                { exa082a.pde }
   'Conduction in a Trapezoidal Plate, PDE Test'
SELECT
   errlim=3e-5     ngrid=1     spectral_colors
VARIABLES
   U
DEFINITIONS
   L1=0.5     L2=0.25     Ly=1     cond= 5.99e7               	{ Copper }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E     Jm=magnitude(J)
   eqn=div( J)							{ Left side of PDE }
EQUATIONS
   div( J)=0
BOUNDARIES
region 'domain'
   start(-L1,0)  value(U)=0  line to (L1,0)
   natural(U)=0 line to (L2,Ly)    					{ Insulated }
   value(U)=1.0 line to (-L2,Ly)
   natural(U)=0 line to close     					{ Insulated }
PLOTS
   contour( U)     surface( U)     vector( E)  norm
   contour( Jx)     contour( Jy)     contour( Jm)
   contour( eqn) as 'Residual'
   elevation( Jy) from (-L1,0) to (L1,0)			{ ? Current }
   elevation( Jy) from (-L2,Ly) to (L2,Ly)
END





